
#|____________________________________________________________________
 |
 | FREQ.LSP - Frequency Analysis, ViSta Program 2
 | Calculates Chi Square, etc. for Frequency tables
 |
 | This is the plugin loader function file
 |_____________________________________________________________________
 |#
;STEP 1: DEFINE THE SEVEN LOCAL VARIABLES 
;        USED TO PREPARE THE PLUGIN ENVIRONMENT

(let* ((plugin-subdirectory "freq")
       (plugin-file         "freqmain.lsp")
       (menu-item           "Frequency Analysis")
       (toolbar-button      "Freqs")
       (workmap-icon        "Frq")
       (data-types        '("class" "category" "freq" "freqclass" "crosstabs" "general"))
       (variable-types    '(numeric category))
       )

  (send *vista* :prepare-plugin-environment
        plugin-subdirectory
        plugin-file 
        menu-item 
        toolbar-button
        workmap-icon
        data-types 
        variable-types ))

  
;STEP 2: DEFINE THE LOADER FUNCTION

  (defun frequency-analysis 
    (&key
     (table-variables nil)
     (control-variables nil)
     (data   *current-data*)
     (dialog nil))
    "Args: &key table-variables control-variables data dialog
ViSta Frequency Analysis Plugin to calculate chi-square and related statistics for n-way frequency data. The analysis is based on the frequency array for the :TABLE-VARIABLES (a variable name string or a list of variable name strings). By default, the first two (or one) ways of the frequency array become the table variables. Additional ways are treated as the control variables, unless they are explicitly specified as :CONTROL-VARIABLES (a variable name string or a list of variable name strings). The remaining keywords have their usual meaning."
    (format t "; CopyRt: FREQ Copyright (c) 1998-2002, by Forrest W. Young & Dominic Moore~%> ")
    (load *freqs-plugin-constructor-file*)
    (frequency-analysis
     :table-variables   table-variables
     :control-variables control-variables
     :data   data
     :dialog dialog))